

const getAllUsers = function(fastify) {
  return (request, reply) => {
    try{
      //const decodedToken = fastify.jwt.decode(token);

      fastify.mysql.getConnection(onConnect);

      function onConnect(err, client) {
        if (err) return reply.send(err);

        client.query(
          `SELECT user_public_id, user_name, user_display_name, user_email, user_admin 
           FROM users 
           ORDER BY user_email`,
          [request.params.user_public_id],
          function onResult(err, result) {
            client.release();
            if(err){
              reply.send(err);  
            } else if( result ){
              reply.send(result);  
            }
          }
        );
      }
    } catch(err){
      reply.send(err)
    }
  };
};

const editUser = function(fastify){
  return (request, reply) => {

      //console.log('decoded: ', decodedToken);
    try{
      fastify.mysql.getConnection(onConnect);

      function onConnect(err, client) {
        if (err) return reply.send(err);
        
        const { user_name, user_password, user_display_name, user_email, user_admin, user_public_id } = request.body;

        if (!user_public_id) {
          fastify.BadRequest(request, reply, "'user_public_id' is required");
          return;
        }

        const fields = [];
        const values = [];
        if(user_name){
          fields.push('user_name=?');
          values.push(user_name);
        }

        if(user_password){
          fields.push('user_password=md5(?)');
          values.push(user_password);
        }

        if(user_display_name){
          fields.push('user_display_name=?');
          values.push(user_display_name);
        }

        if(user_email){
          fields.push('user_email=?');
          values.push(user_email);
        }

        if(user_admin){
          fields.push('user_admin=?');
          values.push(user_admin);
        }

        if(fields.length > 0){
          values.push(user_public_id);

          client.query(
            `UPDATE users SET ${fields.join(',')} WHERE user_public_id=?`,
            values,
            function onResult(err, result) {
              client.release();
              if (err) {
                fastify.BadRequest(request, reply, err);
              } else if (result && result.affectedRows === 1) {
                reply.send({ result: "ok" });
              } else {
                fastify.LoginError(request, reply);
              }
            }
          );
        }
      }
    } catch(err){
      reply.send(err)
    }  
    //reply.send({result: 'ok'});
  };
}

const deleteUser = function(fastify){
  return (request, reply) => {
    try{
      //console.log('decoded: ', decodedToken);

      fastify.mysql.getConnection(onConnect);

      function onConnect(err, client) {
        if (err) return reply.send(err);
        
        const { user_public_id } = request.body;

        if (!user_public_id) {
          fastify.BadRequest(request, reply, "'user_public_id' is required");
          return;
        }

          client.query(
            `DELETE users WHERE user_public_id=?`, [user_public_id],
            function onResult(err, result) {
              client.release();
              if (err) {
                fastify.BadRequest(request, reply, err);
              } else if (result && result.affectedRows === 1) {
                reply.send({ result: "ok" });
              } else {
                fastify.LoginError(request, reply);
              }
            }
          );
      }
    } catch(err){
      reply.send(err);
    }
    //reply.send({result: 'ok'});
  };
}

module.exports = {
  getAllUsers,
  editUser,
  deleteUser
};
