const postHandlers = require("../handlers/post");

const addRoutes = fastify => {
  const tags = [{ name: "post", description: "  -  Post related end-points" }];

  fastify.get(
    "/post/:post_public_id",
    {
      preValidation: (request, reply, done) => {
        fastify.authenticate(request, reply, done);
      },
      schema: {
        description: "Get post info",
        tags: tags,
        summary: "Get post info",
        params: {
          post_public_id: {
            type: "string",
            format: "uuid",
            description: "post public ID"
          }
        },
        body: {},
        response: {
          200: {
            description: "Successful responce",
            type: "object",
            properties: {
              post_public_id: {
                type: "string",
                format: "uuid",
                description: `post's public ID`
              },
              post_title: {
                type: "string",
                description: `post's title`
              },
              post_text: {
                type: "string",
                description: "posts's text"
              },
              post_date_create: {
                type: "string",
                format: "date-time",
                description: "date when the post was created"
              },
              user_public_id: {
                type: "string",
                format: "uuid",
                description: `user's public id`
              }
            }
          }
        },
        security: [
          {
            apiKey: []
          }
        ]
      }
    },
    postHandlers.getPost(fastify)
  );

  fastify.get(
    "/post/my",
    {
      preValidation: (request, reply, done) => {
        fastify.authenticate(request, reply, done);
      },
      schema: {
        description: "Get current user's posts",
        tags: tags,
        summary: "Get current user's posts",
        params: {},
        body: {},
        response: {
          200: {
            description: "Successful responce",
            type: "array",
            items: {
              type: "object",
              properties: {
                post_public_id: {
                  type: "string",
                  format: "uuid",
                  description: `post's public ID`
                },
                post_title: {
                  type: "string",
                  description: `post's title`
                },
                post_text: {
                  type: "string",
                  description: "posts's text"
                },
                post_date_create: {
                  type: "string",
                  format: "date-time",
                  description: "date when the post was created"
                },
                user_public_id: {
                  type: "string",
                  format: "uuid",
                  description: `user's public id`
                }
              }
            }
          }
        },
        security: [
          {
            apiKey: []
          }
        ]
      }
    },
    postHandlers.getMyPosts(fastify)
  );

  fastify.post(
    "/post",
    {
      preValidation: (request, reply, done) => {
        fastify.authenticate(request, reply, done);
      },
      schema: {
        description: `Create a new post`,
        tags: tags,
        summary: `Create a new post`,
        params: {},
        body: {
          type: "object",
          properties: {
            post_title: {
              type: "string",
              description: `post's title`
            },
            post_text: {
              type: "string",
              description: `post's text`
            }
          }
        },
        response: {
          200: {
            description: "Successful crearing",
            type: "object",
            properties: {
              result: { type: "string" }
            }
          }
        },
        security: [
          {
            apiKey: []
          }
        ]
      }
    },
    postHandlers.createPost(fastify)
  );

  //edit [post]
  fastify.put(
    "/post",
    {
      preValidation: (request, reply, done) => {
        fastify.authenticate(request, reply, done);
      },
      schema: {
        description: "Edit current post",
        tags: tags,
        summary: "Editing current post",
        params: {},
        body: {
          type: "object",
          properties: {
            post_public_id: {
              type: "string",
              format: "uuid",
              description: `post's public id`
            },
            post_title: {
              type: "string",
              description: `post's title`
            },
            post_text: {
              type: "string",
              description: `post's text`
            }
          }
        },
        response: {
          200: {
            description: "Successful editing",
            type: "object",
            properties: {
              result: { type: "string" }
            }
          }
        },
        security: [
          {
            apiKey: []
          }
        ]
      }
    },
    postHandlers.editPost(fastify)
  );

  fastify.delete(
    "/post",
    {
      preValidation: (request, reply, done) => {
        fastify.authenticate(request, reply, done);
      },
      schema: {
        description: "Delete post",
        tags: tags,
        summary: "Deleting a post",
        params: {},
        body: {
          type: "object",
          properties: {
            post_public_id: {
              type: "string",
              format: "uuid",
              description: `post's public id`
            }
          }
        },
        response: {
          200: {
            description: "Successful deleting",
            type: "object",
            properties: {
              result: { type: "string" }
            }
          }
        },
        security: [
          {
            apiKey: []
          }
        ]
      }
    },
    postHandlers.deletePost(fastify)
  );
};

module.exports = addRoutes;
