const login = function(fastify) {
  return (request, reply) => {
    try{
      fastify.mysql.getConnection(onConnect);

      function onConnect(err, client) {
        if (err) return reply.send(err);
        const { user, password } = request.body;
        client.query(
          `SELECT user_public_id, user_name, user_display_name, user_email, user_admin, user_id 
          FROM users 
          WHERE user_email=? and user_password=md5(?)`,
          [user, password],
          async function onResult(err, result) {
            client.release();
            console.log('!!!!!!!', err, result, '\n\n\n');
            if (err) {
              fastify.BadRequest(request, reply, err);
            } else if (result && result.length) {
              const user = result[0];
              const token = fastify.jwt.sign({
                user_public_id: user["user_public_id"],
                user_name: user["user_name"],
                user_email: user["user_email"],
                user_admin: user["user_admin"],
                user_id: user["user_id"],
                user_display_name: user["user_display_name"]
              });

              reply.send({ token });
              //reply.send(err || result);
            } else {
              fastify.LoginError(request, reply);
            }
          }
        );
      }
    } catch(err){
      reply.send(err);
    }
  };
};

const signup = function(fastify) {
  return (request, reply) => {

    try{
      fastify.mysql.getConnection(onConnect);

      function onConnect(err, client) {
        if (err) return reply.send(err);
        const { user_name, user_password, user_display_name, user_email } = request.body;
        if (!user_name) {
          fastify.BadRequest(request, reply, "'user_name' is required");
          return;
        }

        if (!user_password) {
          fastify.BadRequest(request, reply, "'user_password' is required");
          return;
        }
        if (!user_display_name) {
          fastify.BadRequest(request, reply, "'user_display_name' is required");
          return;
        }

        if (!user_email) {
          fastify.BadRequest(request, reply, "'user_email' is required");
          return;
        }

        client.query(
          `INSERT INTO users(user_name, user_password, user_display_name, user_email, user_public_id) 
          VALUES(?, md5(?), ?, ?, UUID())`,
          [user_name, user_password, user_display_name, user_email],
          function onResult(err, result) {
            client.release();
            if (err) {
              fastify.BadRequest(request, reply, err);
            } else if (result && result.affectedRows === 1) {
              reply.send({ result: "ok" });
            } else {
              fastify.LoginError(request, reply);
            }
          }
        );
      }
    } catch(err){
      reply.send(err);
    }
  };
};

const getUser = function(fastify) {
  return (request, reply) => {
    try{
      const decodedToken = fastify.jwt.decode(token);
      fastify.mysql.getConnection(onConnect);

      function onConnect(err, client) {
        if (err) return reply.send(err);

        client.query(
          "SELECT user_public_id, user_name, user_display_name, user_email, user_admin FROM users WHERE user_public_id=?",
          [request.params.user_public_id],
          function onResult(err, result) {
            client.release();
            if(err){
              reply.send(err);  
            } else if(result && result.length > 0){
              reply.send(result[0]);  
            }
          }
        );
      }
    } catch(err){
      reply.send(err);
    }
  };
};

const getUserCurrent = function(fastify) {
  return (request, reply) => {
    try{
      const decodedToken = fastify.getTokenDecoded(request, reply);
      if (decodedToken) {
        //console.log('decoded: ', decodedToken);

        fastify.mysql.getConnection(onConnect);

        function onConnect(err, client) {
          if (err) return reply.send(err);

          client.query(
            `SELECT user_public_id, user_name, user_display_name, user_email, user_admin 
            FROM users 
            WHERE user_public_id=?`,
            [decodedToken["user_public_id"]],
            function onResult(err, result) {
              client.release();
              reply.send(err || result[0]);
            }
          );
        }
      }
    } catch(err){
      reply.send(err);
    }
    //reply.send({result: 'ok'});
  };
};

const editCurrentUser = function(fastify){
  return (request, reply) => {
    try{
      const decodedToken = fastify.getTokenDecoded(request, reply);
      if (decodedToken) {
        //console.log('decoded: ', decodedToken);

        fastify.mysql.getConnection(onConnect);

        function onConnect(err, client) {
          if (err) return reply.send(err);
          
          const { user_name, user_password, user_display_name, user_email, user_admin } = request.body;
          const fields = [];
          const values = [];
          if(user_name){
            fields.push('user_name=?');
            values.push(user_name);
          }

          if(user_password){
            fields.push('user_password=md5(?)');
            values.push(user_password);
          }

          if(user_display_name){
            fields.push('user_display_name=?');
            values.push(user_display_name);
          }

          if(user_email){
            fields.push('user_email=?');
            values.push(user_email);
          }

          if(user_admin){
            fields.push('user_admin=?');
            values.push(user_admin);
          }

          if(fields.length > 0){
            values.push(decodedToken["user_public_id"]);

            client.query(
              `UPDATE users SET ${fields.join(',')} WHERE user_public_id=?`,
              values,
              function onResult(err, result) {
                client.release();
                if (err) {
                  fastify.BadRequest(request, reply, err);
                } else if (result && result.affectedRows === 1) {
                  reply.send({ result: "ok" });
                } else {
                  fastify.LoginError(request, reply);
                }
              }
            );
          }

          
        }
      }
    } catch(err){
      reply.send(err);
    }
    //reply.send({result: 'ok'});
  };
}

module.exports = {
  login,
  signup,
  getUser,
  getUserCurrent,
  editCurrentUser
};
