const fp = require("fastify-plugin")

module.exports = fp(async function(fastify, opts) {
  

  fastify.register(require('fastify-swagger'), {
    routePrefix: '/docs',
    swagger: {
      info: {
        title: 'REST API documentation ',
        description: 'short documentation how to use server api endpoints',
        version: '0.0.1'
      },
      externalDocs: {
        url: 'https://swagger.io',
        description: 'Find more info here'
      },
      host: 'localhost',
      schemes: ['http', 'https'],
      consumes: ['application/json'],
      produces: ['application/json'],
      tags: [
        /* { name: 'user', description: 'User related end-points' }, */
        /* { name: 'code', description: 'Code related end-points' } */
      ],
      definitions: {
        /* User: {
          $id: 'User',
          type: 'object',
          required: ['user_public_id', 'user_email', 'user_name', 'user_password'],
          properties: {
            user_public_id: { type: 'string', format: 'uuid', nullable: false },
            user_email: { type: 'string', format: 'email', nullable: false },
            user_name: { type: 'string', nullable: false },
            user_password: { type: 'string', nullable: false },
            user_admin: { type: 'boolean', nullable: false },
          }
        } */
      },
      securityDefinitions: {
        apiKey: {
          type: 'apiKey',
          name: "apiKey",
          in: 'header'
        }
      }
    },
    exposeRoute: true
  })
  
 /*  fastify.put('/some-route/:id', {
    schema: {
      description: 'post some data',
      tags: ['user', 'code'],
      summary: 'qwerty',
      params: {
        type: 'object',
        properties: {
          id: {
            type: 'string',
            description: 'user id'
          }
        }
      },
      body: {
        type: 'object',
        properties: {
          hello: { type: 'string' },
          obj: {
            type: 'object',
            properties: {
              some: { type: 'string' }
            }
          }
        }
      },
      response: {
        201: {
          description: 'Successful response',
          type: 'object',
          properties: {
            hello: { type: 'string' }
          }
        }
      },
      security: [
        {
          "apiKey": []
        }
      ]
    }
  }, (req, reply) => {}) */
  
  fastify.ready(err => {
    if (err) throw err
    fastify.swagger()
  })
})
