const adminUserHandlers = require("../handlers/admin");

const addRoutes = fastify => {
  //edit user
  fastify.put(
    "/admin/user",
    {
      preValidation: (request, reply, done) => {
        fastify.isAdmin(request, reply, done);
      },
      schema: {
        description: "Edit user",
        tags: [{ name: "admin", description: "Admin related end-points" }],
        summary: "Editing user",
        params: {},
        body: {
          type: "object",
          properties: {
            user_public_id: {
              type: "string",
              format: "uuid",
              description: "user to edit"
            },
            user_email: {
              type: "string",
              description: `user's email`
            },
            user_name: {
              type: "string",
              description: `user's name`
            },
            user_display_name: {
              type: "string",
              description: `user's display name`
            },
            user_password: {
              type: "string",
              description: `user's password`
            },
            user_admin: {
              type: "boolean",
              description: `user is admin`
            }
          }
        },
        response: {
          200: {
            description: "Successful editing",
            type: "object",
            properties: {
              result: { type: "string" }
            }
          }
        },
        security: [
          {
            apiKey: []
          }
        ]
      }
    },
    adminUserHandlers.editUser(fastify)
  );

  fastify.get(
    "/admin/users",
    {
      preValidation: (request, reply, done) => {
        fastify.isAdmin(request, reply, done);
      },
      schema: {
        description: "get all users",
        tags: [{ name: "admin", description: "Admin related end-points" }],
        summary: "get all users",
        params: {},
        body: {},
        response: {
          200: {
            description: "Successful getting",
            type: "array",
            items: {
              //$ref: '#/components/schemas/User',
              type: "object",
              properties: {
                user_public_id: {
                  type: "string",
                  format: "uuid",
                  description: `user's public id`
                },
                user_email: {
                  type: "string",
                  description: `user's email`
                },
                user_name: {
                  type: "string",
                  description: `user's name`
                },
                user_display_name: {
                  type: "string",
                  description: `user's display name`
                },
                user_password: {
                  type: "string",
                  description: `user's password`
                },
                user_admin: {
                  type: "boolean",
                  description: `user is admin`
                }
              }
            }
          }
        },
        security: [
          {
            apiKey: []
          }
        ]
      }
    },
    adminUserHandlers.getAllUsers(fastify)
  );

  fastify.delete(
    "/admin/user",
    {
      preValidation: (request, reply, done) => {
        fastify.isAdmin(request, reply, done);
      },
      schema: {
        description: "delete a user",
        tags: [{ name: "admin", description: "Admin related end-points" }],
        summary: "delete a user",
        params: {},
        body: {
          type: "object",
          properties: {
            user_public_id: {
              type: "string",
              format: "uuid",
              description: `user's public id`
            }
          }
        },
        response: {
          200: {
            description: "Successful deleting",
            type: "object",
            properties: {
              token: { type: "string" }
            }
          }
        },
        security: [
          {
            apiKey: []
          }
        ]
      }
    },
    adminUserHandlers.deleteUser(fastify)
  );
};

module.exports = addRoutes;
