const userHandlers = require("../handlers/user");

const tags = [{ name: "user", description: "  -  User related end-points" }];

const addRoutes = fastify => {
  fastify.get(
    "/user/:user_public_id",
    {
      preValidation: (request, reply, done) => {
        fastify.authenticate(request, reply, done);
      },
      schema: {
        description: "Get user info",
        tags: tags,
        summary: "Get user info",
        params: {
          user_public_id: {
            type: "string",
            format: "uuid",
            description: "user public ID"
          }
        },
        body: {},
        response: {
          200: {
            description: "Successful responce",
            type: "object",
            properties: {
              user_public_id: {
                type: "string",
                format: "uuid",
                description: `user's public ID`
              },
              user_email: {
                type: "string",
                description: `user's email`
              },
              user_admin: {
                type: "boolean",
                description: "user is admin"
              },
              user_name: {
                type: "string",
                description: `user's name`
              },
              user_display_name: {
                type: "string",
                description: `user's display name`
              }
            }
          }
        },
        security: [
          {
            apiKey: []
          }
        ]
      }
    },
    userHandlers.getUser(fastify)
  );
  fastify.get(
    "/user/current",
    {
      preValidation: (request, reply, done) => {
        fastify.authenticate(request, reply, done);
      },
      schema: {
        description: `Get current user's profile data`,
        tags: tags,
        summary: `Get current user's profile data`,
        params: {},
        body: {},
        response: {
          200: {
            description: "Successful responce",
            type: "object",
            properties: {
              user_public_id: {
                type: "string",
                format: "uuid",
                description: `user's public ID`
              },
              user_email: {
                type: "string",
                description: `user's email`
              },
              user_admin: {
                type: "boolean",
                description: "user is admin"
              },
              user_name: {
                type: "string",
                description: `user's name`
              },
              user_display_name: {
                type: "string",
                description: `user's display name`
              }
            }
          }
        },
        security: [
          {
            apiKey: []
          }
        ]
      }
    },
    userHandlers.getUserCurrent(fastify)
  );

  //edit user
  fastify.put(
    "/user",
    {
      preValidation: (request, reply, done) => {
        fastify.authenticate(request, reply, done);
      },
      schema: {
        description: "Edit current user",
        tags: tags,
        summary: "Editing current user",
        params: {},
        body: {
          type: "object",
          properties: {
            user_email: {
              type: "string",
              description: `user's email`
            },
            user_name: {
              type: "string",
              description: `user's name`
            },
            user_display_name: {
              type: "string",
              description: `user's display name`
            },
            user_password: {
              type: "string",
              description: `user's password`
            }
          }
        },
        response: {
          200: {
            description: "Successful loggin",
            type: "object",
            properties: {
              result: { type: "string" }
            }
          }
        },
        security: [
          {
            apiKey: []
          }
        ]
      }
    },
    userHandlers.editCurrentUser(fastify)
  );

  fastify.post(
    "/login",
    {
      schema: {
        description: "Log in into the system",
        tags: tags,
        summary: "Log in into the system",
        params: {},
        body: {
          type: "object",
          properties: {
            user: {
              type: "string",
              description: `user's email`
            },
            password: {
              type: "string",
              description: "user password"
            }
          }
        },
        response: {
          200: {
            description: "Successful loggin",
            type: "object",
            properties: {
              token: { type: "string" }
            }
          }
        },
        security: []
      }
    },
    userHandlers.login(fastify)
  );

  fastify.post(
    "/signup",
    {
      schema: {
        description: "Register new user",
        tags: tags,
        summary: "Register new user",
        params: {},
        body: {
          type: "object",
          properties: {
            user_email: {
              type: "string",
              description: `user's email`
            },
            user_name: {
              type: "string",
              description: "user name"
            },
            user_password: {
              type: "string",
              description: "user password"
            },
            user_display_name: {
              type: "string",
              description: "user display name"
            }
          }
        },
        response: {
          200: {
            description: "Successful registration",
            type: "object",
            properties: {
              result: {
                type: "string",
                description: "== ok"
              }
            }
          }
        },
        security: []
      }
    },
    userHandlers.signup(fastify)
  );
};

module.exports = addRoutes;
